﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1250" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">

    class Comparer: IComparer {
		public int Compare(object a, object b) {
			DefinicjaElementu da = (DefinicjaElementu)a;
			DefinicjaElementu db = (DefinicjaElementu)b;
			return da.Nazwa.CompareTo(db.Nazwa);
		}
    }
    
    
	void OnContextLoad(Object sender, EventArgs args) {
		Row[] rows = (Row[])dc[typeof(Row[])];

		Hashtable ht = new Hashtable();
		
		foreach (ListaPlac lista in rows)
			foreach (Wyplata wyplata in lista.Wyplaty)
				foreach (WypElement element in wyplata.Elementy)
					if (ht[element.Definicja]==null)
						ht.Add(element.Definicja, true);
						
		ArrayList definicje = new ArrayList(ht.Keys);
		definicje.Sort(new Comparer());
		
		Write("Numer");
		Write("Data");
		Write("Data wypłaty");
		Write("Okres");
		Write("Lp");
		Write("Pracownik");
		
		Write("Brutto");
		Write("Składki pracownika");
		Write("Koszty uzyskania");
		Write("Podstawa opodatkowania");
		Write("Ulga podatkowa");
		Write("Składka zdrowotna");
		Write("Składka zdrowotna do doliczenia");
		Write(""/*"Składka zdrowotna odliczona"*/);
		Write("Zaniechanie poboru zaliczki");
		Write("Zaliczka podatku");		
		
		Write("Emerytalna/U");
		Write("Emerytalna/P");
		Write("Rentowa/U");
		Write("Rentowa/P");
		Write("Chorobowa");
		Write("Wypadkowa");
		Write("Zdrowotna");
		Write("FP");
		Write("FGŚP");
        Write("FEP");
		
		foreach (DefinicjaElementu definicja in definicje)
			Write(definicja.Nazwa);
			
		Write("Gotówka");		
		WriteLn("ROR");
		
		SumyElementow.Wypłaty.SumyElementowWorker worker = new SumyElementow.Wypłaty.SumyElementowWorker();
		Wyplata.PITInfoWorker pit = new Wyplata.PITInfoWorker();
		WyplataSkładkiWorker zus = new WyplataSkładkiWorker();
		
		worker.Session = dc.Session;
		foreach (ListaPlac lista in rows) {
			Write(lista.Numer);
			Write(lista.Data);
			Write(lista.DataWyplaty);
			Write(lista.Okres);
			WriteLn("");

			bool any = false;			
			foreach (Wyplata wyplata in lista.Wyplaty) {
				any = true;
				Write();
				Write();
				Write();
				Write();
				Write(wyplata.Numer.Numer);
				Write(wyplata.Pracownik);	

				pit.Wypłata = wyplata;
				Write(pit.Brutto);
				Write(pit.SkładkiZUS);
				Write(pit.KosztyFIS);
				Write(pit.Podstawa);
				Write(pit.Ulga);
				Write(pit.SkładkaZdrow);
				Write(pit.ZdrowotneDoOdliczenia);
				Write(""/*pit.ZdrowotneFaktycznieOdliczon e*/);
				Write(pit.ZanFIS);
				Write(pit.ZalFIS);		

				zus.Wypłata = wyplata;
				Write(zus.Razem.Emerytalna.Prac);
				Write(zus.Razem.Emerytalna.Firma);
				Write(zus.Razem.Rentowa.Prac);
				Write(zus.Razem.Rentowa.Firma);
				Write(zus.Razem.Chorobowa.Prac + zus.Razem.Chorobowa.Firma);
				Write(zus.Razem.Wypadkowa.Prac + zus.Razem.Wypadkowa.Firma);
				Write(zus.Razem.Zdrowotna.Prac + zus.Razem.Zdrowotna.Firma);
				Write(zus.Razem.FP.Firma);
				Write(zus.Razem.FGSP.Firma);
                Write(zus.Razem.FEP.Firma);
				
				worker.Wyplata = wyplata;				
							
				foreach (DefinicjaElementu definicja in definicje) {
					string nazwa = definicja.Nazwa.Replace('.', '_');
					Write(worker.WgElementu[nazwa].Wartość);
				}
				
				Write(wyplata.Gotówka.Value);		
				Write(wyplata.Inne.Value);
				WriteLn("");
			}		
			if (!any)				
				WriteLn("");
		}
	}
	
	bool first_row = true;
	
	void WriteLn(object obj) {
		Write(obj);
		_Write("\r\n");
	}
	
	void Write(decimal d) {
		if (d==0m)
			Write("");
		else
			Write(d.ToString());
	}
	
	void Write() {
		Write("");
	}
	
	void Write(object obj) {
		_Write((obj==null ? "" : obj.ToString()) + ";");
	}
	
	void _Write(string s) {
		Response.Write(s);
	}
	
	//Pomocne w trakcie szukania błądów
	static void Msg(object obj) {
	}

</script>
<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[],Soneta.Business" />
